C Typical problem setup for DQ1DA C 
       DOUBLE PRECISION A, B, EPS, R, E
C
         A = 0.0D0
         B = 1.0D0          
C Set interval endpoints to [0,1]
         EPS = 0.1D-02       
C Set accuracy request for three digits
         CALL DQ1DA (A,B,EPS,R,E,KF,IFLAG)
         WRITE(*,*)'         INTERVAL: '
         WRITE(*,'(3X,D18.10,3X,D18.10)') A,B
         WRITE(*,*)  
         WRITE(*,*)'         DQ1DA RESULTS: '
         WRITE(*,1) EPS,R,E,KF,IFLAG
    1    FORMAT(3X,D18.10,3X,D18.10,3X,D18.10,3X,I5,2X,I5)
         WRITE(*,*)
         WRITE(*,*)'REFERENCE RESULTS ON IBM PC/AT (CALLED DUNI)'
         WRITE(*,*)'    0.0000000000E+00     0.1000000000E+01',
     *'    0.1000000000E-02     0.4140675161E-01     0.4286574121E-11',
     *'      30      0'
         END
C
         DOUBLE PRECISION FUNCTION F(X)
         DOUBLE PRECISION X
C Define integrand F
         F = DSIN(2.0D0*X)-DSQRT(X)     
         RETURN 
         END
